function ans = chris_step_inject_juggler(inData)
% chris_step_inject_juggler
% chris_step_inject_juggler(inData)
%
% Juggles step injections data from the Excel table (Spikes data CURRENT.xlsx),
% extracting all proper ISIs and spike information from it.
% BEWARE: The program assumes that 3 sheets is reads from the xls file are all perfectly aligned (rows match
% each other: same number, same sorting).

% Aug 30 2014: Created
% Sep 04 2014: Output adjusted.
% Sep 09 2014: Debugging & reworking.

fileName = 'C:\Users\Arseny\Documents\4_Chris Classification\2014 data\Spikes data CURRENT.xlsx';
sheet3sp = 'first3sp';
sheetSp  = 'SpikePerInjection';
sheetKey = 'key';

if(nargin<1)
    fprintf('Reading a file now... ');
    temp1  = xlsread(fileName,sheet3sp);
    ans{1} = temp1;
    temp2  = xlsread(fileName,sheetSp);
    ans{2} = temp2;
    temp3  = xlsread(fileName,sheetKey);
    ans{3} = temp3;
    fprintf('Done\n');
    %return
else
    ans = [];
    temp1 = inData{1};
    temp2 = inData{2};
    temp3 = inData{3};
end

ids       = temp1(4:end,1);
data      = temp1(4:end,13:end);       % All data for 3 first spikes. Period of 18 columns
spPerInj  = temp2(3:end,3:end);        % Spikes per injection
bestTrace = temp3(:,3);

nCell   = length(ids);

% figure; hold on;
% temp = spline(1:10,spPerInj,1:0.1:10)';
% plot(temp,'g-');
% plot(mean(temp'),'k-');
% hold off;

isi21 = nan(nCell,1);
mv12  = nan(nCell,1);
mv13  = nan(nCell,1);
bestISI = nan(nCell,1);

% First let's estimate top spiking interval for every cell
for(q=1:nCell)    
    fs = find(spPerInj(q,:)>0,1,'first');   % First spike
    if(~isempty(fs))                        % If spiked at all   
        fstSp(q) = fs;
        maxSp(q) = max(spPerInj(q,:));         % Maximum spiking achieved for this cell
        best = find(spPerInj(q,:)==maxSp(q));  % Looking for the best current injection (the one that produced most spikes)
        if(length(best)>1)                  % If several currents produced same number of spikes
            bestOfBest = find(abs(best-5)==min(abs(best-5)),1,'first');
            best = best(bestOfBest);        % ... select the one closer to the center of the currents range
        end
    end   
    topTrace(q) = best;
end


fprintf('     id           top range         best range      threshold mV       amplitude mV      risetime ms      width ms       best ISI, ms      ISI 2/1       mV 2/1\n');
for(q=1:nCell)    
    best = bestTrace(q);    
    if(best>0)                              % If spiked at all
        offset1st = (fstSp(q)-2)*18;
        offsetBst = (best-2)*18;               % where "best" range is stored in first-3-spikes data        
        if(maxSp(q)>1)            
            bestISI(q) = data(q,offsetBst+5)-data(q,offsetBst+4);     % first ISI in the "best" range.
            mv12(q) = data(q,offsetBst+10)/data(q,offsetBst+11);      % Ratio of 2nd and 1st spike amplitudes
        else
            bestISI(q) = NaN;
            mv12(q) = NaN;
        end
        if(maxSp(q)>2)                                                      % At least 3 spikes somewhere
            isi21(q) = (data(q,offsetBst+6)-data(q,offsetBst+5))/bestISI(q);      % Ratio of 2nd and 1st ISIs            
        else
            isi21(q) = NaN;            
        end
        
        dth     = data(q,offset1st+1)-data(q,offset1st+10);                 % These 4 measurements are based on 1st spikes ever, not on best spikes
        damp    = data(q,offset1st+10);
        drise   = data(q,offset1st+13);
        dwidth  = data(q,offset1st+16);
        dispf([ids(q) topTrace(q) bestTrace(q) dth damp drise dwidth bestISI(q) isi21(q) mv12(q)],'%12.3f');
    end        
end

% figure;
% subplot(1,2,1); plot(bestISI,mv12,'.'); xlabel('ISI_{best}'); ylabel('Amp_1 / Amp_2');
% subplot(1,2,2); plot(isi21,mv12,'.');   xlabel('ISI_2 / ISI_1');

figure('Color','white');
subplot(1,2,1); enum(bestISI,mv12,ids); xlabel('ISI_{best}');       ylabel('Amp_1 / Amp_2');
subplot(1,2,2); enum(isi21  ,mv12,ids); xlabel('ISI_2 / ISI_1');    ylabel('Amp_1 / Amp_3');

% figure; plot(bestISI,'.-'); hold on;
% for(q=1:length(bestISI))
%     text(q,bestISI(q),num2str(bestISI(q)));
% end

end